'==========================================================================
'
'	NAME: CreateContentFolders.vbs
'***********************************************************************
' THIS CODE AND INFORMATION IS PROVIDED TO YOU FOR YOUR REFERENTIAL 
' PURPOSES ONLY, AND IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, 
' EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED 
' WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR PURPOSE, 
' AND MAY NOT BE REDISTRIBUTED IN ANY MANNER.
' 
' Copyright (c) Microsoft Corporation.  All rights reserved.
'***********************************************************************
'
'==========================================================================


'Validate that the share exists
Function CreateCustomerRoot(strWebRoot,strCustomerName)
	
	Dim strCustomerRoot
	Dim strDriveName
	'Check to see if the drive root exists
	strDriveName = oFSO.GetDriveName(strWebRoot)
	If not oFSO.DriveExists(strDriveName) Then
		'Bail out because the drive doesn't exist
		strError=strDriveName & " doesn't exist. Script Aborting."
		WScript.Echo strError
		WScript.Quit
	Else
		'create the root
		strCustomerRoot = strWebRoot & "\" & strCustomerName
		If Not oFSO.FolderExists(strCustomerRoot) Then
			Set oFolder = oFSO.CreateFolder(strCustomerRoot)
		Else
			Set oFolder = oFSO.GetFolder(strCustomerRoot)
		End If
		strCustomerRoot = oFolder.Path 
		Set oFolder = Nothing
	End If
	CreateCustomerRoot = strCustomerRoot
End Function

Public Function CreatePath(strPath)
'***********************************************************
'	Name: CreatePath
'	Purpose: Recursively creates a folder structure
'	Inputs:	strPath - Full path of the folder structure

'	Output: Full path of the content folder
'	
'**********************************************************
	Dim oFolder
	Dim strReturn
	'Loop through the folder structure until all folders exist
	Do Until oFSO.FolderExists(strPath) = True
		'If the parent folder exisits, create the child
		If oFSO.FolderExists(oFSO.GetParentFolderName(strPath)) Then
			set oFolder = oFSO.CreateFolder(strPath)
			'Return the created folder structure
			CreatePath = oFolder.Path
			Write oLogFile,"Created " & oFolder.Path,err_info,bDebug
		Else
			'Send the parent to this function for creation
			strReturn = CreatePath(oFSO.GetParentFolderName(strPath))
		End If
	Loop
End Function

Public Function CreateSampleContent(strHH,strPath)
	Dim strContentFile
	Dim oFile
	strContentFile = strPath & "\web\content\Default.htm"
	oFSO.CreateTextFile(strContentFile)
	Set oFile = oFSO.OpenTextFile(strContentFile,2)
	oFile.WriteLine "<H1>Welcome to " & strHH & ".</H1>"
	oFile.Close
	CreateSampleContent = "Created " & strContentFile


End Function